<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Serverless\V1\Service\Build;

use Twilio\ListResource;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
class BuildStatusList extends ListResource {
    /**
     * Construct the BuildStatusList
     *
     * @param Version $version Version that contains the resource
     * @param string $serviceSid The SID of the Service that the Build resource is
     *                           associated with
     * @param string $sid The unique string that identifies the Build resource
     */
    public function __construct(Version $version, string $serviceSid, string $sid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['serviceSid' => $serviceSid, 'sid' => $sid, ];
    }

    /**
     * Constructs a BuildStatusContext
     */
    public function getContext(): BuildStatusContext {
        return new BuildStatusContext(
            $this->version,
            $this->solution['serviceSid'],
            $this->solution['sid']
        );
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Serverless.V1.BuildStatusList]';
    }
}